"use client";

import Link from "next/link";
import { useState } from "react";

export default function AdminLogin() {
  const [key, setKey] = useState("");

  function save() {
    try { localStorage.setItem("ADMIN_KEY", key.trim()); } catch {}
    window.location.href = "/admin";
  }

  return (
    <main className="min-h-screen grid place-items-center bg-neutral-950 text-white">
      <div className="w-full max-w-md px-6">
        <div className="rounded-3xl border border-white/10 bg-white/5 p-6">
          <div className="text-2xl font-semibold">Admin Login</div>
          <div className="mt-2 text-sm text-neutral-300">
            Fut <span className="font-semibold">ADMIN_KEY</span> nga `.env`.
          </div>

          <input
            value={key}
            onChange={(e) => setKey(e.target.value)}
            placeholder="ADMIN_KEY"
            className="mt-4 w-full rounded-xl border border-white/10 bg-black/40 px-3 py-2 text-sm text-white outline-none focus:border-white/25"
          />

          <button
            onClick={save}
            className="mt-4 w-full rounded-xl bg-white px-4 py-2 text-sm font-semibold text-black hover:bg-neutral-200"
          >
            Ruaj & Vazhdo
          </button>

          <div className="mt-4 text-xs text-neutral-400">
            Keshille: perdor nje key te gjate (gjenero me <code className="rounded bg-black/40 px-2 py-1">npm run gen:admin-key</code>).
          </div>

          <div className="mt-5">
            <Link className="text-xs text-neutral-300 underline underline-offset-4" href="/">
              Kthehu te Home
            </Link>
          </div>
        </div>
      </div>
    </main>
  );
}
