import { requireAdmin, adminError } from "@/lib/admin";
import { createEvent, listEvents } from "@/lib/store";

export async function GET(req) {
  if (!requireAdmin(req)) return adminError();
  const events = await listEvents();
  return new Response(JSON.stringify({ events }), { headers: { "content-type": "application/json" } });
}

export async function POST(req) {
  if (!requireAdmin(req)) return adminError();
  const body = await req.json();
  const event = await createEvent(body);
  return new Response(JSON.stringify({ event }), { headers: { "content-type": "application/json" } });
}
