import nodemailer from "nodemailer";

function configured() {
  return Boolean(process.env.SMTP_HOST && process.env.SMTP_USER && process.env.SMTP_PASS);
}

export function emailConfigured() {
  return configured();
}

export function mailFrom() {
  return process.env.MAIL_FROM || "Ftesa Digjitale <noreply@example.com>";
}

export function createTransporter() {
  if (!configured()) return null;

  const secure = (process.env.SMTP_SECURE || "false").toLowerCase() === "true";
  const port = parseInt(process.env.SMTP_PORT || (secure ? "465" : "587"), 10);

  return nodemailer.createTransport({
    host: process.env.SMTP_HOST,
    port,
    secure,
    auth: {
      user: process.env.SMTP_USER,
      pass: process.env.SMTP_PASS,
    },
  });
}

export async function sendInviteEmail({ to, subject, html, text }) {
  const transporter = createTransporter();
  if (!transporter) return { ok: false, reason: "not_configured" };

  const info = await transporter.sendMail({
    from: mailFrom(),
    to,
    subject,
    text,
    html,
  });

  return { ok: true, messageId: info.messageId };
}
