import { createEvent, addGuests } from "../lib/store.js";

async function run() {
  const event = await createEvent({
    coupleA: "Arlind",
    coupleB: "Iris",
    dateISO: new Date(Date.now() + 1000*60*60*24*30).toISOString(),
    venueName: "Restorant Demo",
    venueAddress: "Prishtine",
    mapsUrl: "https://maps.google.com/?q=Prishtine",
    dressCode: "Elegant",
    notes: "Ky eshte event demo per testim.",
    itinerary: [
      { label: "Mbërritja", time: "19:00" },
      { label: "Ceremonia", time: "19:30" },
      { label: "Darka", time: "20:30" },
    ],
  });

  const created = await addGuests(event.id, [{ name: "Mysafir Demo", email: "", phone: "" }]);
  const token = created?.[0]?.invite?.token || "demo-token";

  console.log("Seed OK");
  console.log("Event:", event.id);
  console.log("Invite token:", token);
  console.log("Open:", `/i/${token}`);
}

run().catch((e) => {
  console.error(e);
  process.exit(1);
});
