try { require('dotenv').config(); } catch {}
const { createServer } = require('http');
const next = require('next');
const url = require('url');

const port = parseInt(process.env.PORT || '3000', 10);
const dev = process.env.NODE_ENV !== 'production';

const app = next({ dev });
const handle = app.getRequestHandler();

app.prepare().then(() => {
  createServer((req, res) => {
    const parsedUrl = url.parse(req.url, true);
    handle(req, res, parsedUrl);
  }).listen(port, '0.0.0.0', () => {
    console.log(`> Ready on http://localhost:${port} (NODE_ENV=${process.env.NODE_ENV || 'development'})`);
  });
}).catch((err) => {
  console.error('Failed to start server:', err);
  process.exit(1);
});
